/************************************************************************
 * Copyright 2006-2010 Silicon Software GmbH
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License (version 2) as
 * published by the Free Software Foundation.
 */
#ifndef MENABLE_IOCTL_H
#define MENABLE_IOCTL_H

#ifndef __KERNEL__
#include <stdint.h>
#endif

#include <linux/time.h>

#define MEN_IOCTL(name, x) \
	IOCTL_##name = (x)

#if BITS_PER_LONG > 32

#define MEN_IOCTL64(name, x) \
	IOCTL_##name##32 = (x), \
	MEN_IOCTL(name, ((x) + 128))

#else /* BITS_PER_LONG > 32 */

#define MEN_IOCTL64(name, x) \
	IOCTL_##name##32 = (x), \
	MEN_IOCTL(name, x)

#endif /* BITS_PER_LONG > 32 */

struct men_io_range32 {
	uint32_t start;
	uint32_t length;
	int subnr;
	unsigned int headnr;
} __attribute__ ((packed));

struct men_io_range {
	unsigned long start;
	unsigned long length;
	long subnr;
	unsigned int headnr;
} __attribute__ ((packed));

struct men_io_bufidx32 {
	unsigned int headnr;
	int index;
};

struct men_io_bufidx {
	unsigned int headnr;
	long index;
};

struct men_io_bufwait32 {
	int index;
	unsigned int dmachan;
	unsigned int timeout;
};

struct men_io_bufwait {
	long index;
	unsigned int dmachan;
	unsigned int timeout;
};

struct men_eeprom {
	uint32_t buf[35];
};

struct men_io_buflen {
	uint32_t dma;
	long index;
	size_t len;
};

struct mm_create_s32 {
	uint64_t maxsize;
	unsigned int subbufs;
};

struct mm_create_s {
	uint64_t maxsize;
	long subbufs;
};

struct l_design_settings {
	unsigned int irq_read;
	unsigned int irq_ack;
	unsigned int irq_start;
	unsigned int dma_len[2];

	unsigned int dmatag[2];

	unsigned int localirq;

	struct userintqueue {
		unsigned int address;
		unsigned char tag;
		unsigned char burstlen;
		unsigned char shift;
	} userintqueue[8];
};

struct mm_cmd_lock_s {
	unsigned long *inBuffer;
	unsigned long *outBuffer;
	unsigned long InLen;
	unsigned long OutLen;
	unsigned long *mdl_in;
	unsigned long *mdl_out;
};

struct mm_cmd_alloc_s {
	unsigned long NumberOfBytes;
	unsigned long log_buf_num;
	unsigned char *Address;
	unsigned long BaseAddress;
	unsigned long FrameLength;
	unsigned long LineLength;
	int			  nFlag;
	int			  nDir;
};

struct mm_cmd_s {
	union mm_cmd_u {
		struct mm_cmd_lock_s mm_cmd_lock;
		struct mm_cmd_alloc_s mm_cmd_alloc;
	} u;
};

struct fg_ctrl_s {
	unsigned int cmd;

	union {
		struct fg_start_s {
			int start_param;
			int param;
			unsigned int timeout;
			unsigned int chan;
			unsigned int act_size;
			int mode;
			unsigned int head;
			unsigned int start_buf;
			int dma_mode;
			int transfer_todo;
			unsigned int dma_dir;
		} fg_start;
	} u;
};

struct fg_ctrl {
	int mode;
	int timeout;
	long transfer_todo;
	unsigned int chan;
	unsigned int head;
	long start_buf;
	int dma_dir;
};

struct dma_timestamp32 {
	unsigned int head;
	int buf;
	struct timespec stamp;
};

struct dma_timestamp {
	unsigned int head;
	long buf;
	struct timespec stamp;
};

struct handshake_frame {
	union {
		struct {
			unsigned int head;
			unsigned int mode;
		};
		long long frame;
	};
};

struct bufstatus {
	union {
		struct {
			unsigned int head;
			long long index;
		} idx;
		struct {
			long long free;
			long long grabbed;
			long long locked;
			long long lost;
			unsigned int is_locked;
		} status;
	};
};

#include "men_ioctl_codes.h"

struct siso_menable;

extern void warn_wrong_iosize(struct siso_menable *men, unsigned int cmd,
		const size_t expsize);

#endif
