/* -----------------------------------------------------------
 *
 * Copyright (c) 1997  Silicon Software GmbH
 *
 * -----------------------------------------------------------*/

#ifndef __MEN_IOCTL_CODES_H
#define __MEN_IOCTL_CODES_H

enum men_ioctl_codes {
#ifndef LINUX
	MEN_IOCTL(MAPMEM_MAP_USER_PHYSICAL_MEMORY, 0),
	MEN_IOCTL(MAPMEM_UNMAP_USER_PHYSICAL_MEMORY, 1),
	MEN_IOCTL(GET_VERSION, 6),
#endif /* LINUX */
	MEN_IOCTL64(FG_START_TRANSFER, 21),
	MEN_IOCTL64(ALLOCATE_VIRT_BUFFER, 24),
	MEN_IOCTL(FREE_VIRT_BUFFER, 25),
	MEN_IOCTL(FG_STOP_CMD, 27),
	MEN_IOCTL64(FG_WAIT_FOR_SUBBUF, 29),
	MEN_IOCTL(FG_TEST_BUF_STATUS, 30),
	MEN_IOCTL(DESIGN_SETTINGS, 31),
	MEN_IOCTL(DMA_LENGTH, 33),
	MEN_IOCTL(RESSOURCE_CONTROL, 36),
	MEN_IOCTL(DMA_TIME_STAMP, 37),
#ifdef _WIN32
	MEN_IOCTL(UIQ_CMD, 38),
#endif /* _WIN32 */
	MEN_IOCTL(UNLOCK_BUFFER_NR, 40),
	MEN_IOCTL64(ADD_VIRT_USER_BUFFER, 41),
	MEN_IOCTL(GET_HANDSHAKE_DMA_BUFFER, 42),
	MEN_IOCTL64(GET_BUFFER_STATUS, 43),
	MEN_IOCTL(DEL_VIRT_USER_BUFFER, 44),
	MEN_IOCTL(DMA_TAG, 45),
	MEN_IOCTL(GET_EEPROM_DATA, 51),
	MEN_IOCTL(SET_EEPROM_DATA, 52),

/* obsolete ADD_VIRT_USER_BUFFER64 for Runtime 3.5.x   81 */
/* obsolete ALLOCATE_VIRT_BUFFER64 for Runtime 3.5.x   82 */

#ifndef LINUX
	MEN_IOCTL(RESOURCE_NAME_WRITE, 136),
	MEN_IOCTL(RESOURCE_NAME_READ, 137),
#endif /* LINUX */

	MEN_IOCTL(BOARD_INFO, 200),
	MEN_IOCTL(PP_CONTROL, 201),
#ifndef LINUX
	MEN_IOCTL(UIQ_WRITE, 577),
	MEN_IOCTL(UIQ_SCALE, 578),

#ifdef QNX
	MEN_IOCTL(QNX_DESIGN_NAME_R, 512),
	MEN_IOCTL(QNX_DESIGN_NAME_W, 513),
	MEN_IOCTL(QNX_DESIGN_CLOCK_R, 514),
	MEN_IOCTL(QNX_DESIGN_CLOCK_W, 515),
	MEN_IOCTL(QNX_UIQ_READ, 576),
	MEN_IOCTL(QNX_UIQ_INTCNT_R, 579),
	MEN_IOCTL(QNX_UIQ_LOST_R, 581),
	MEN_IOCTL(QNX_UIQ_FILL_R, 582),
	MEN_IOCTL(QNX_UIQ_FILL_W, 583),
#endif /* QNX */

	MEN_IOCTL(UIQ_FLUSH, 584)
#endif /* LINUX */

};

/* HANDSHAKE COMMANDS */

#define SEL_ACT_IMAGE		200
#define SEL_NEXT_IMAGE		220

#define DMA_CONTMODE		0x10
#define DMA_HANDSHAKEMODE	0x20
#define DMA_BLOCKINGMODE	HANDSHAKEMODE
#define DMA_PULSEMODE		0x30

#endif /* __MEN_IOCTL_CODES_H */
