import os
from fabric.api import run, env, cd


ROOT_SOURCE = 'ftp://root.cern.ch/root/root_v5.34.05.source.tar.gz'
ROOT_CFLAGS = ' '.join(['--enable-mathmore',
                        '--enable-minuit2',
                        '--enable-fftw3',
                        '--enable-xml',
                        '--prefix=/usr/local'])

VTK_SOURCE = 'http://www.vtk.org/files/release/5.10/vtk-5.10.1.tar.gz'

env.use_ssh_config = True
env.user = 'root'
env.hosts = ['compute1',
             'compute2']


def wget(url):
    run('wget %s' % url)


def untar(filename):
    run('tar xfz %s' % filename)


def basepath(path):
    return os.path.join('$HOME', 'software', path)


def fetch():
    with cd(basepath('.')):
        wget(ROOT_SOURCE)
        untar(os.path.basename(ROOT_SOURCE))

        wget(VTK_SOURCE)
        untar(os.path.basename(VTK_SOURCE))


def install():
    fetch()

    with cd(basepath('root')):
        run('./configure %s' % ROOT_CFLAGS)
        run('make -j12')
        run('make install')

    with cd(basepath('VTK5.10.1')):
        run('cmake . -DBUILD_SHARED_LIBS=ON -DCMAKE_BUILD_TYPE=Release')
        run('make -j12')
        run('make install')


def deploy():
    run('zypper in gsl gsl-devel')
    install()
    run('ldconfig')
