#include <gmodule.h>
#ifdef __APPLE__
#include <OpenCL/cl.h>
#else
#include <CL/cl.h>
#endif

#include <ufo/ufo-resource-manager.h>
#include <ufo/ufo-filter.h>
#include <ufo/ufo-buffer.h>
#include "ufo-filter-test.h"

#define KRFNAME "test.cl"
#define KRNAME  "my_filter"
#define INNAME  "input"
#define OUTNAME "output"

//#define DEBUG

struct _UfoFilterTestPrivate {
	cl_kernel kernel;
};

//GType ufo_filter_test_get_type(void) G_GNUC_CONST;

G_DEFINE_TYPE(UfoFilterTest, ufo_filter_test, UFO_TYPE_FILTER);

#define UFO_FILTER_TEST_GET_PRIVATE(obj) (G_TYPE_INSTANCE_GET_PRIVATE((obj), UFO_TYPE_FILTER_TEST, UfoFilterTestPrivate))

enum {
    PROP_0,
    N_PROPERTIES
};

static void ufo_filter_test_initialize(UfoFilter *filter)
{
    UfoFilterTest *self = UFO_FILTER_TEST(filter);
    UfoResourceManager *manager = ufo_resource_manager();
    GError *error = NULL;

    /*self->priv->kernel = NULL;
    ufo_resource_manager_add_program(manager, KRFNAME, NULL, &error);
    if (error != NULL) {
        g_warning("%s", error->message);
        g_error_free(error);
        return;
    }
*/
//  self->priv->kernel = ufo_resource_manager_get_kernel(manager, KRNAME, &error);
    self->priv->kernel = ufo_resource_manager_get_kernel(manager, KRFNAME, KRNAME, &error); //!!!
    if (error != NULL) {
        g_warning("%s", error->message);
        g_error_free(error);
    }
}

static void ufo_filter_test_process(UfoFilter *filter)
{
    g_return_if_fail(UFO_IS_FILTER(filter));

    cl_command_queue command_queue = (cl_command_queue) ufo_filter_get_command_queue(filter);

    UfoFilterTest *self = UFO_FILTER_TEST(filter);
    UfoFilterTestPrivate *priv = UFO_FILTER_TEST_GET_PRIVATE(self);

    UfoChannel *input_channel  = ufo_filter_get_input_channel (filter);
    UfoChannel *output_channel = ufo_filter_get_output_channel(filter);

    UfoBuffer *input1  = ufo_channel_get_input_buffer(input_channel);
    UfoBuffer *input2  = ufo_channel_get_input_buffer(input_channel);
    UfoBuffer *output = NULL;

    guint num_dims = 0;
    guint *dimensions = NULL;
    ufo_buffer_get_dimensions(input1, &num_dims, &dimensions);

    cl_int error = CL_SUCCESS;

    cl_kernel kernel = NULL;
    kernel = priv->kernel;

    ufo_channel_allocate_output_buffers(output_channel, 2, dimensions);

    size_t global_work_size[2] = { dimensions[0], dimensions[1] };

    //#ifdef DEBUG
      int nit = 0;
	//#endif

    while (input2 != NULL && input1 != NULL) {
		//#ifdef DEBUG
        	g_message("Iteration: %d", nit);
        	nit = nit + 1;
		//#endif

        output = ufo_channel_get_output_buffer(output_channel);

        cl_event event;

        cl_mem input1_mem  = (cl_mem) ufo_buffer_get_device_array(input1,  command_queue);
        cl_mem input2_mem  = (cl_mem) ufo_buffer_get_device_array(input2,  command_queue);
        cl_mem output_mem = (cl_mem) ufo_buffer_get_device_array(output, command_queue);

        error  = clSetKernelArg(kernel, 0, sizeof(cl_mem), &input1_mem);
        error |= clSetKernelArg(kernel, 1, sizeof(cl_mem), &input2_mem);
        error |= clSetKernelArg(kernel, 2, sizeof(cl_mem), &output_mem);
        CHECK_OPENCL_ERROR(error);

        CHECK_OPENCL_ERROR(clEnqueueNDRangeKernel(command_queue, kernel, 2, NULL, global_work_size, NULL, 0, NULL, &event));

        ufo_filter_account_gpu_time(filter, (void **) &event);
        ufo_buffer_transfer_id(input2, output);

        ufo_channel_finalize_input_buffer (input_channel,  input1);
        ufo_channel_finalize_output_buffer(output_channel, output);

        input1 = input2;
        input2 = ufo_channel_get_input_buffer(input_channel);
    }
    ufo_channel_finalize_input_buffer (input_channel,  input1);
    ufo_channel_finish(output_channel);
}

static void ufo_filter_test_set_property(GObject *object,
    guint           property_id,
    const GValue    *value,
    GParamSpec      *pspec)
{
    switch (property_id) {
        default:
            G_OBJECT_WARN_INVALID_PROPERTY_ID(object, property_id, pspec);
            break;
    }
}

static void ufo_filter_test_get_property(GObject *object,
    guint       property_id,
    GValue      *value,
    GParamSpec  *pspec)
{
    switch (property_id) {
        default:
            G_OBJECT_WARN_INVALID_PROPERTY_ID(object, property_id, pspec);
            break;
    }
}

static void ufo_filter_test_class_init(UfoFilterTestClass *klass)
{
    GObjectClass *gobject_class = G_OBJECT_CLASS(klass);
    UfoFilterClass *filter_class = UFO_FILTER_CLASS(klass);

    gobject_class->set_property = ufo_filter_test_set_property;
    gobject_class->get_property = ufo_filter_test_get_property;
    filter_class->initialize = ufo_filter_test_initialize;
    filter_class->process = ufo_filter_test_process;

    g_type_class_add_private(gobject_class, sizeof(UfoFilterTestPrivate));
}

static void ufo_filter_test_init(UfoFilterTest *self)
{
    UfoFilterTestPrivate *priv = self->priv = UFO_FILTER_TEST_GET_PRIVATE(self);

    ufo_filter_register_input(UFO_FILTER(self), INNAME, 2);
    ufo_filter_register_output(UFO_FILTER(self), OUTNAME, 2);
}

G_MODULE_EXPORT UfoFilter *ufo_filter_plugin_new(void)
{
    return g_object_new(UFO_TYPE_FILTER_TEST, NULL);
}
